/**
 * @file error_codes.h
 *
 * @brief The error codes for the Optima.
 *
 * Revision information:
 *
 * $HeadURL: http://ultrasvn/svn/Magicard/Optima/SharedHeaders/trunk/error_codes.h $
 * $LastChangedDate: 2015-03-02 09:09:32 +0000 (Mon, 02 Mar 2015) $
 * $LastChangedRevision: 5629 $
 * $LastChangedBy: ctamblyn $
 *
 * @copyright Ultra Electronics Ltd.
 *
 ******************************************************************************/

#ifndef ERROR_CODES_H_
#define ERROR_CODES_H_

/******************************************************************************/

#include "optima_types.h"

/******************************************************************************/

/**
 * The printer error code type.
 */
typedef uint32 ERROR_CODE;

/******************************************************************************/

#define ERR_NO_ERROR             0 /**< Dummy error code indicating that all is well. */

/******************************************************************************/

/*
 * OS and PCB error codes.
 */
//#define ERR_FLASH_VERIFY         12
//#define ERR_FLASH_ID_ERROR       13
#define ERR_FLASH_WRITE_ERROR    14
#define ERR_FLASH_READ_ERROR     15
//#define ERR_FLASH_ERASE_ERROR    16
//#define ERR_PORT_CLOSED          17  /**< For RS232, I2C & SPI ports when not needed! */
//#define ERR_DEVICE_ERROR         18

//#define ERR_TOO_MANY_RFID_TAGS             33
//#define ERR_INVALID_RFID_TAG               34

//#define ERR_RFID_FAILURE                   36
//#define ERR_TRANSFER_FILM_TAG_NOT_DETECTED 37
//#define ERR_DYE_FILM_TAG_NOT_DETECTED      38
//#define ERR_NO_FILM_TAGS_DETECTED          39

//#define ERR_RFID_ANTENNA_ERROR      100
//#define ERR_NO_SPI_FLASH_RESPONSE   101
//#define ERR_NO_SPI_RFID_RESPONSE    102
//#define ERR_NO_SPI_FPGA_RESPONSE    103
#define ERR_FPGA_PROGRAMMING_ERROR  104
//#define ERR_FPGA_VERSION_ERROR      105
//#define ERR_BACKUP_STORAGE_ERROR    106
//#define ERR_5V_OUT_OF_RANGE_ERROR   107
//#define ERR_3V3_OUT_OF_RANGE_ERROR  108
//#define ERR_STEPPER_MOTOR_TIMEOUT   109
//#define ERR_TEMP_SENSOR_FAILURE     110

/*
 * Print engine error codes.
 */

#define ERR_FEATURE_UNAVAILABLE           1024  /**< The requested feature is not available. */
#define ERR_HOPPER_EMPTY                  1025  /**< A card could not be extracted from the hopper. */
#define ERR_CARD_JAM                      1026  /**< The card got stuck in the print engine. */
#define ERR_FLIPPER_JAM                   1027  /**< The flipper could not be rotated. */
#define ERR_INVALID_JOB_OPTION            1028  /**< A parameter in a job was invalid. */
#define ERR_HEATED_ROLLER_TIMEOUT         1029  /**< Timeout while waiting for heated roller to reach target. */
#define ERR_HEATED_ROLLER_CAM             1030  /**< Timeout while opening or closing the heated roller cam. */
#define ERR_PRINT_ROLLER_CAM              1031  /**< Timeout while opening or closing the print roller cam. */
#define ERR_DYE_FILM_PANEL_TIMEOUT        1032  /**< Timeout while trying to wind to next/previous dye panel. */
#define ERR_DYE_FILM_PANEL_UNAVAILABLE    1033  /**< A dye panel was requested that is not provided by the fitted film type. */
#define ERR_TRANSFER_FILM_PANEL_TIMEOUT   1034  /**< Timeout while trying to wind to next/previous transfer panel. */
#define ERR_MAG_HEAD_HOME_TIMEOUT         1035  /**< Timeout while trying to return the mag head to the home position. */
#define ERR_MAG_HEAD_MOVE_TIMEOUT         1036  /**< Timeout while trying to clear the mag head sensor. */
#define ERR_MAG_VERIFY                    1037  /**< The mag encoder failed to correctly read data on a card. */
#define ERR_COVER_OPENED                  1038  /**< The cover was opened during a job. */

#define ERR_TRANSFER_FILM_EXPIRED         1041  /**< The transfer film has run out of prints. */
#define ERR_DYE_FILM_EXPIRED              1042  /**< The dye film has run out of prints. */
#define ERR_BOTH_FILMS_EXPIRED            1043  /**< Both films expired during printing. */
#define ERR_INDEX_LED_CALIBRATION_FAILED  1044  /**< Calibration of the index LED failed. */
#define ERR_DYE_LED_CALIBRATION_FAILED    1045  /**< Calibration of the dye LED failed. */
#define ERR_DYE_FILM_NOT_FOUND            1046  /**< Dye film is needed, but none is fitted. */
#define ERR_TRANSFER_FILM_NOT_FOUND       1047  /**< Transfer film is needed, but none is fitted. */
#define ERR_FILM_FITTED                   1048  /**< Film is fitted when it should not be e.g. during cleaning. */
#define ERR_NO_FILM_FITTED                1049  /**< Neither roll of film was detected. */

#define ERR_MISCELLANEOUS                 8191  /**< An error not covered by the other error codes. */

#define ERR_HEATER_OVERTEMPERATURE        9000  /**< The heated roller is too hot. */
#define ERR_PRINTHEAD_OVERTEMPERATURE     9001  /**< The printhead is too hot. */
#define ERR_HEATER_SENSOR_DISCONNECTED    9002  /**< The heated roller temperature sensor is returning invalid values. */
#define ERR_PRINTHEAD_DISCONNECTED        9003  /**< The printhead temperature sensor is returning invalid values. */

/******************************************************************************/

#endif /* ERROR_CODES_H_ */
